<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams_namazeg_answer_sheet_progress', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->foreignId('school_id')->constrained('schools')->onDelete('cascade');
            $table->foreignId('schoolClass_id')->constrained('school_classes')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_namazeg_answer_sheet_progress');
    }
};
