<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_minus_student_descions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('v_student_punishment_id');
            $table->unsignedBigInteger('namazeg_version_id');
            $table->unsignedBigInteger('student_id');
            $table->integer('descion_number');
            $table->string('date');
            $table->text('return_condition');

            $table->foreign('student_id', 'fk_student_id_2')->references('id')->on('school_students')->onDelete('cascade');
            $table->foreign('namazeg_version_id', 'fk_deleteversi_2')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('v_student_punishment_id', 'fk_deletev_s_punis_2')->references('id')->on('violation_student_punishments')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_minus_student_descions');
    }
};
