<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_destruction_proceeds', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('v_student_punishment_id');
            $table->unsignedBigInteger('namazeg_version_id');
            $table->integer('decision_number');
            $table->string('meeting_date');
            $table->string('destruction_date');
            $table->string('invention_date');
            $table->string('crime_time');
            $table->text('details');
            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('v_student_punishment_id')->references('id')->on('violation_student_punishments')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_destruction_proceeds');
    }
};
