<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDateAndDateTypeToTableExamDaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('table_exam_days', function (Blueprint $table) {
            // Adding 'date' as a varchar and 'date_type' as an ENUM, both nullable
            $table->string('date')->after('semester_week_day_id')->nullable();
            $table->enum('date_type', ['hijri', 'coptic'])->after('date')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('table_exam_days', function (Blueprint $table) {
            // Dropping the 'date' and 'date_type' columns if the migration is rolled back
            $table->dropColumn(['date', 'date_type']);
        });
    }
}
