<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRoundToTableExamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('table_exams', function (Blueprint $table) {
            // Adding the 'round' column as an ENUM with 'first' and 'second' as values, and making it nullable
            $table->enum('round', ['first', 'second'])->after('exam_type')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('table_exams', function (Blueprint $table) {
            // Dropping the 'round' column if the migration is rolled back
            $table->dropColumn('round');
        });
    }
}
