<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('supervision_schedules', function (Blueprint $table) {
            $table->unsignedBigInteger('namazeg_version_id')->nullable()->after('id');
            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
        });
        Schema::table('proceeds', function (Blueprint $table) {
            $table->unsignedBigInteger('namazeg_version_id')->nullable()->after('id');
            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('supervision_schedules', function (Blueprint $table) {
            $table->dropForeign(['namazeg_version_id']);
            $table->dropColumn('namazeg_version_id');
        });
        
        Schema::table('proceeds', function (Blueprint $table) {
            $table->dropForeign(['namazeg_version_id']);
            $table->dropColumn('namazeg_version_id');
        });
        
    }
};
