<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('supervisors', function (Blueprint $table) {
            $table->enum('type',['day','follow'])->default('day');
            $table->unsignedBigInteger('floor_id')->nullable()->change();

        });
        
        
    }
    
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('supervisors', function (Blueprint $table) {
            $table->dropColumn('type');
            $table->unsignedBigInteger('floor_id')->nullable(false)->change();

        });
    }
};
