<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSchoolEmployeeAttendanceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('school_employee_attendance', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id')->nullable();
            $table->unsignedBigInteger('school_employee_id')->nullable();
            $table->enum('status', ['attended', 'absent', 'late'])->nullable();
            $table->enum('absence_reason', ['without_excuse', 'sick', 'emergency', 'accompanying', 'newborn', 'other'])->nullable();
            $table->text('other_absence_reason')->nullable();
            $table->text('late_reason')->nullable();
            $table->string('late_from_time', 50)->nullable();
            $table->string('late_to_time', 50)->nullable();
            $table->string('date', 50)->nullable();
            $table->enum('date_type', ['hijri', 'coptic'])->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('school_employee_id')->references('id')->on('school_employees')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('school_employee_attendance');
    }
}
