<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_evacuation_plan_images', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->unsignedBigInteger('school_id');

            $table->unsignedBigInteger('namazeg_evacuation_id');
            $table->string('image');

            $table->foreign('namazeg_evacuation_id','evacuation_delete')->references('id')
                ->on('namazeg_evacuation_plan_reports')->onDelete('cascade');

            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_evacuation_plan_images');
    }
};
