<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTableExamDaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('table_exam_days', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('table_exam_id');
            $table->unsignedBigInteger('class_name_id')->nullable();
            $table->unsignedBigInteger('class_id')->nullable();
            $table->unsignedBigInteger('semester_week_day_id');
            $table->integer('n_exams');
            $table->string('subject_ids', 255);

            $table->foreign('table_exam_id')->references('id')->on('table_exams')->onDelete('cascade');
            $table->foreign('class_name_id')->references('id')->on('class_names')->onDelete('cascade');
            $table->foreign('class_id')->references('id')->on('school_classes')->onDelete('cascade');
            $table->foreign('semester_week_day_id')->references('id')->on('semester_week_days')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('table_exam_days');
    }
}
