<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assignment_teams', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('team_id');
            $table->string('date');
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            $table->foreign('team_id')->references('id')->on('teams')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assignment_teams');
    }
};
