<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('class_visit_cards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('classVisit_id');
            $table->string('teacher_nationality')->nullable();
            $table->string('teacher_qualification')->nullable();
            $table->string('teaching_field')->nullable();
            $table->string('direct_school_date')->nullable();
            $table->enum('visit_type', ['supervisory'])->default('supervisory');
            $table->enum('teacher_new_to_subject',['yes','no'])->default('yes');
            $table->set('visit_method_ids', [1,2,3,4,5,6,7]);
            $table->longText('additional_methods')->nullable();
            $table->timestamps();

            $table->foreign('classVisit_id')->references('id')->on('class_room_visit_sessions')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('class_visit_cards');
    }
};
