<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('class_room_visit_sessions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('semester_id');
            $table->unsignedBigInteger('school_teacher_id');
           
            $table->unsignedBigInteger('school_class_id')->nullable();
            $table->string('date')->nullable();
            $table->enum('date_type', ['coptic', 'hijri'])->nullable();
            $table->unsignedBigInteger('visit_officer_id');
            $table->unsignedBigInteger('visit_period_id');
            $table->enum('visit_status', ['incomplete', 'complete'])->default('incomplete');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('semester_id')->references('id')->on('semesters')->onDelete('cascade');
            $table->foreign('school_teacher_id')->references('id')->on('school_employees')->onDelete('cascade');
            $table->foreign('school_class_id')->references('id')->on('school_classes')->onDelete('cascade');
            $table->foreign('visit_officer_id')->references('id')->on('school_employees')->onDelete('cascade');
            $table->foreign('visit_period_id')->references('id')->on('periods')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('class_room_visit_sessions');
    }
};
