<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('student_general_circulars_students', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('student_general_circular_id');
            $table->unsignedBigInteger('student_id');
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraint for parent student general circular
            $table->foreign('student_general_circular_id', 'sgc_students_sgc_id_fk')->references('id')->on('student_general_circulars')->onDelete('cascade');
            // Foreign key constraint for parent student
            $table->foreign('student_id', 'sgc_students_student_id_fk')->references('id')->on('school_students')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('student_general_circulars_students');
    }
};
