<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('classroom_visits', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('school_id');
            $table->unsignedBigInteger('semester_id');
            $table->unsignedBigInteger('visiting_teacher_id');
            $table->unsignedBigInteger('visited_teacher_id');
            $table->unsignedBigInteger('period_id');
            $table->unsignedBigInteger('subject_id');
            $table->unsignedBigInteger('school_class_id')->nullable();
            $table->enum('date_type',['hijri','coptic']);
            $table->string('date');
            $table->timestamps();

            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('semester_id')->references('id')->on('semesters')->onDelete('cascade');
            $table->foreign('visiting_teacher_id')->references('id')->on('school_employees');
            $table->foreign('visited_teacher_id')->references('id')->on('school_employees');
            $table->foreign('period_id')->references('id')->on('periods');
            $table->foreign('subject_id')->references('id')->on('subjects');
            $table->foreign('school_class_id')->references('id')->on('school_classes')->onDelete('cascade');


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('classroom_visits');
    }
};
