<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSchoolSubjectTeachersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('school_subject_teachers', function (Blueprint $table) {
            $table->id();  // Creates an auto-incrementing primary key (INT)
            $table->unsignedBigInteger('school_id')->nullable();  // Creates a BIGINT column for school_id, nullable
            $table->unsignedBigInteger('subject_id')->nullable();  // Creates a BIGINT column for subject_id, nullable
            $table->unsignedBigInteger('school_employee_id')->nullable();  // Creates an INT column for type_value_id, nullable
            $table->timestamps();  // Adds 'created_at' and 'updated_at' columns

            $table->foreign('school_employee_id')->references('id')->on('school_employees')->onDelete('cascade');
            $table->foreign('subject_id')->references('id')->on('subjects')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('school_subject_teachers');
    }
}
