<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subjects', function (Blueprint $table) {
            $table->bigIncrements('id');  // UNSIGNED BIGINT, auto-incrementing primary key
            $table->string('name', 150)->collation('utf8mb4_unicode_ci');  // VARCHAR(150), NOT NULL with specified collation
            $table->unsignedBigInteger('school_grade_id');  // UNSIGNED BIGINT, NOT NULL
            $table->unsignedBigInteger('class_name_id')->nullable();  // BIGINT, nullable
            $table->unsignedBigInteger('semester_id')->nullable();  // BIGINT, nullable
            $table->timestamp('created_at')->nullable();  // TIMESTAMP, nullable
            $table->timestamp('updated_at')->nullable();  // TIMESTAMP, nullable
            $table->timestamp('deleted_at')->nullable();  // TIMESTAMP, nullable for soft deletes
        
            $table->foreign('school_grade_id')->references('id')->on('school_grades')->onDelete('cascade');
            $table->foreign('class_name_id')->references('id')->on('class_names')->onDelete('cascade');
            $table->foreign('semester_id')->references('id')->on('semesters')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subjects');
    }
}
