<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('alerts', function (Blueprint $table) {
            $table->id();
            $table->enum('type',['verbal','written']);
            $table->enum('date_type',['hijri','coptic']);
            $table->string('date');
            $table->unsignedBigInteger('alert_direct_to');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('alert_direct_to')->references('id')->on('school_employees')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('alerts');
    }
};
