<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg', function (Blueprint $table) {
            $table->id();
            $table->integer('form_number');
            $table->string('name', 150)->nullable();
            $table->text('details')->nullable();
            $table->enum('type',['procedures','violations','others'])->default('others');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg');
    }
};
