<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSchoolsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('schools', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->enum('shift', ['morning', 'evening', 'night'])->nullable();
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->enum('childhood', ['yes', 'no'])->default('no')->nullable();
            $table->unsignedBigInteger('school_grade_id')->nullable();
            $table->string('name', 100)->nullable();
            $table->string('ministry_number', 100)->nullable();
            $table->enum('education_type', ['governmental', 'family'])->nullable();
            $table->unsignedBigInteger('education_department_id')->nullable();
            $table->unsignedBigInteger('educational_office_id')->nullable();
            $table->string('founding_date', 25)->nullable();
            $table->enum('founding_date_type', ['coptic', 'hijri'])->nullable();
            $table->string('address', 150)->nullable();
            $table->unsignedBigInteger('area_id')->nullable();
            $table->unsignedBigInteger('city_id')->nullable();
            $table->string('current_school_year', 50)->nullable();
            $table->enum('reg_step1', ['completed', 'incompleted'])->default('incompleted');
            $table->enum('reg_step2', ['completed', 'incompleted'])->default('incompleted');
            $table->enum('reg_step3', ['completed', 'incompleted'])->default('incompleted');
            $table->enum('reg_step4', ['completed', 'incompleted'])->default('incompleted');
            $table->enum('reg_step5', ['completed', 'incompleted'])->default('incompleted');
            $table->enum('reg_step6', ['completed', 'incompleted'])->default('incompleted');
            $table->enum('reg_step7', ['completed', 'incompleted'])->default('incompleted');
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('school_grade_id')->references('id')->on('school_grades')->onDelete('cascade');
            $table->foreign('education_department_id')->references('id')->on('educational_departments')->onDelete('cascade');
            $table->foreign('educational_office_id')->references('id')->on('educational_offices')->onDelete('cascade');
            $table->foreign('area_id')->references('id')->on('areas')->onDelete('set null');
            $table->foreign('city_id')->references('id')->on('cities')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('schools');
    }
}
