<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

use App\Models\Event;
use Illuminate\Support\Str;
use Carbon\Carbon;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Event>
 */
class EventFactory extends Factory
{
    protected $model = Event::class;
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'date' => $this->faker->date($format = 'd/m/Y', $max = 'now'),
            'date_type' => $this->faker->randomElement(['coptic', 'hijri']),
            'time_from' => $this->faker->time($format = 'H:i'),
            'time_to' => $this->faker->time($format = 'H:i'),
            'details' => $this->faker->sentence,
        ];
    }
}
