<?php

namespace Database\Factories\AdminDashboard\Category;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Category>
 */
class CategoryFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'parent_id' => null, // Example of a root category
            'name' => $this->faker->word,
            'board_type' => $this->faker->randomElement(['teacher', 'manager']),
            'page_url' => $this->faker->url,
            'status' => '1',
        ];
    }
}
