<?php

namespace App\Traits;

use App\Models\ManagerDashboard\Settings\Subscription;
use App\Models\User;
use http\Env\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Mail;

trait SmsTrait
{
    public function sendOTP($phone, $otp)
    {

        $app_id = "TzRtDE0zHklF2RgxEA0x6a3jLg3h2ZFNp0Fkpffb";
        $app_sec = "CSeQzUJ3DW3h9OxvTG5liZH7WvelwfdTVSvBFUwVQ5VLfDlmlNsd15vp93lAHmyjytDZ61kRO9Oi1JkqUtiDeDBtYiwFgWvrWl0j";
        $app_hash = base64_encode("{$app_id}:{$app_sec}");

        $messages = [
            "messages" => [
                [
                    "text" => "رمز التحقق الخاص بك هــو" . $otp,
                    "numbers" => ["966$phone"],
                    "sender" => "LAAM"
                ]
            ]
        ];

        $url = "https://api-sms.4jawaly.com/api/v1/account/area/sms/send";
        $headers = [
            "Accept: application/json",
            "Content-Type: application/json",
            "Authorization: Basic {$app_hash}"
        ];

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($messages));
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($curl);
        $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        //$response_json = json_decode($response, true);

        /** send otp via email **/
        //$this->sendOtpViaEmail($phone,$otp);
    }

    public function sendResetPassword($phone, $tempPassword)
    {

        $app_id = "TzRtDE0zHklF2RgxEA0x6a3jLg3h2ZFNp0Fkpffb";
        $app_sec = "CSeQzUJ3DW3h9OxvTG5liZH7WvelwfdTVSvBFUwVQ5VLfDlmlNsd15vp93lAHmyjytDZ61kRO9Oi1JkqUtiDeDBtYiwFgWvrWl0j";
        $app_hash = base64_encode("{$app_id}:{$app_sec}");

        $messages = [
            "messages" => [
                [
                    "text" => "كلمة المرور المؤقتة الخاصة بك هي " . $tempPassword,
                    "numbers" => ["966$phone"],
                    "sender" => "LAAM"
                ]
            ]
        ];

        $url = "https://api-sms.4jawaly.com/api/v1/account/area/sms/send";
        $headers = [
            "Accept: application/json",
            "Content-Type: application/json",
            "Authorization: Basic {$app_hash}"
        ];

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($messages));
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($curl);
        $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        //$response_json = json_decode($response, true);


    }


    public function sendSystemAccount($phone, $userId){

        $app_id = "TzRtDE0zHklF2RgxEA0x6a3jLg3h2ZFNp0Fkpffb";
        $app_sec = "CSeQzUJ3DW3h9OxvTG5liZH7WvelwfdTVSvBFUwVQ5VLfDlmlNsd15vp93lAHmyjytDZ61kRO9Oi1JkqUtiDeDBtYiwFgWvrWl0j";
        $app_hash = base64_encode("{$app_id}:{$app_sec}");

        // Retrieve user information
        $user = User::find($userId);
        $tempPassword = Str::random(8);
        $user->password_reseted = 'no';
        $user->password = bcrypt($tempPassword);
        $user->save();

        $messages = [
            "messages" => [
                [
                    "text" => "مرحبًا {$user->name}, البريد الإلكتروني: {$user->email} وكلمة المرور المؤقتة الخاصة بك هي {$tempPassword}",
                    "numbers" => ["966$phone"],
                    "sender" => "LAAM"
                ]
            ]
        ];

        $url = "https://api-sms.4jawaly.com/api/v1/account/area/sms/send";
        $headers = [
            "Accept: application/json",
            "Content-Type: application/json",
            "Authorization: Basic {$app_hash}"
        ];

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($messages));
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($curl);
        $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);

        //$response_json = json_decode($response, true);

        ////// send account credentials email////////
        $data = ['user' => $user,'temp_password'=>$tempPassword];
        Mail::send('emails/registered_school_employee', $data, function($msg) use ($user) {
            $msg->to($user->email, 'Laam App')->subject('Account Credentials');
            $msg->from(config('mail.from.address'), config('mail.from.name'));
        });
    }

    /** method will be used to send sms notification */
    public static function sendSMSNotification($phone, $SMSBody, $user_id = null){
        if (!Str::startsWith($phone, '05')) {
            return [
                'success' => false,
                'message' => 'Invalid phone number. Phone number must start with 05.',
            ];
        }

        // Check balance before sending SMS
        $balanceCheck = static::getBalance();
        if (!$balanceCheck['can_send']) {
            return [
                'success' => false,
                'message' => $balanceCheck['message'], // "Insufficient balance" or other message from getBalance
            ];
        }

        $app_id = "TzRtDE0zHklF2RgxEA0x6a3jLg3h2ZFNp0Fkpffb";
        $app_sec = "CSeQzUJ3DW3h9OxvTG5liZH7WvelwfdTVSvBFUwVQ5VLfDlmlNsd15vp93lAHmyjytDZ61kRO9Oi1JkqUtiDeDBtYiwFgWvrWl0j";
        $app_hash = base64_encode("{$app_id}:{$app_sec}");
        $url = "https://api-sms.4jawaly.com/api/v1/account/area/sms/send";

        $messages = [
            "messages" => [
                [
                    "text" => $SMSBody,
                    "numbers" => ["966$phone"],
                    "sender" => "LAAM"
                ]
            ]
        ];

        $headers = [
            "Accept: application/json",
            "Content-Type: application/json",
            "Authorization: Basic {$app_hash}"
        ];

        DB::beginTransaction();

        try {
            if ($user_id) {
                $consumed_response = static::consumeSMSCount($user_id);
            } else {
                $consumed_response = true; // For super admin messages
            }

            if ($consumed_response) {
                $curl = curl_init($url);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($messages));
                curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

                $response = curl_exec($curl);
                $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                curl_close($curl);

                if ($status_code === 200) {
                    DB::commit();
                    return [
                        'success' => true,
                        'message' => 'SMS sent successfully.',
                    ];
                } else {
                    throw new \Exception("SMS API error: HTTP {$status_code}");
                }
            }
        } catch (\Exception $e) {
            DB::rollBack();
            return [
                'success' => false,
                'message' => $e->getMessage(),
            ];
        }
    }

    /** method will be used to consume sms count of user sms quote  */
    public static function consumeSMSCount($userId){
        $smsSubscription = Subscription::where('user_id', $userId)
            ->where('service_type', 'sms')
            ->whereIn('status', ['subscribed', 'Experimental'])->latest()->firstOrFail();

        if ($smsSubscription) {
            $smsSubscription->messages_consumed -= 1;
            $smsSubscription->save();

            if ($smsSubscription->messages_consumed == 0) {
                $smsSubscription->status = 'not_subscribed';
                $smsSubscription->save();
            }
            return true;
        } else {
            return false;
            // throw new \Exception('عفوا باقه الرسائل منتهيه حاليا');
            // return response()->json(['error'=>'عفوا باقه الرسائل منتهيه حاليا']);
        }
    }

    public static function getBalance(){
        $app_id = "TzRtDE0zHklF2RgxEA0x6a3jLg3h2ZFNp0Fkpffb";
        $app_sec = "CSeQzUJ3DW3h9OxvTG5liZH7WvelwfdTVSvBFUwVQ5VLfDlmlNsd15vp93lAHmyjytDZ61kRO9Oi1JkqUtiDeDBtYiwFgWvrWl0j";

        $app_hash  = base64_encode("$app_id:$app_sec");
        $base_url = "https://api-sms.4jawaly.com/api/v1/";
        $query = [
            "is_active" => 1,
            "order_by" => "id",
            "order_by_type" => "desc",
            "page" => 1,
            "page_size" => 10,
            "return_collection" => 1,
        ];

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $base_url . 'account/area/me/packages?' . http_build_query($query),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Content-Type: application/json',
                'Authorization: Basic ' . $app_hash
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);

        $responseData = json_decode($response, true);

        if (!isset($responseData['data']) || empty($responseData['data'])) {
            return ['can_send' => false, 'message' => 'No active balance packages available'];
        }

        // Check for sufficient points (example logic)
        $balance = $responseData['data'][0]['current_points'] ?? 0;
        return [
            'can_send' => $balance > 0,
            'balance' => $balance,
            'message' => $balance > 0 ? 'Sufficient balance available' : 'Insufficient balance',
        ];
    }

    protected function sendOtpViaEmail($phone,$otp){
        $user = User::where('phone', $phone)->first();
        if($user){
            $data = ['otp' => $user->verification_code];

            Mail::send('emails/otp-verfication', $data, function($msg) use ($user) {
                $msg->to($user->email, 'Laam App')->subject('OTP Verfication');
                $msg->from(config('mail.from.address'), config('mail.from.name'));
            });
        }

    }

}
