<?php

namespace App\Traits;

use App\Models\Notification;
use App\Models\NotificationReceptor;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Kreait\Firebase\Factory;

trait NotificationTrait
{
    protected $messaging;
    // public function __construct()
    // {
    //     $this->messaging = (new Factory)
    //         ->withServiceAccount(storage_path('app/google-services.json'))
    //         ->createMessaging();
    // }

    // --------------  Website Notification
    public static function CreateWebsiteNotification(
        $note_enum_id,
        string $title,
        string $body,
        $school_id,
        array $user_ids,
        string $type = "bell",
        string $model = null,
        $model_id = null,
        $data_id = null,
        string $date = null,
        string $receptor = "specific_receptors"
    ) {
        $notification = Notification::updateOrCreate(
            [
                'note_enum_id' => $note_enum_id,
                'model' => $model,
                'model_id' => $model_id,
                'body' => $body,
                'date' => $date,
                'title' => $title,
                'receptor' => $receptor,
                'type' => $type,
                'data_id' => $data_id,
                'notification_type' => 'website'
            ],
            [
                'scheduled' => $date ? 1 : 0,
                'date_type' => 'coptic',
            ]
        );
        foreach ($user_ids as $user_id) {
            if ($type == "bell") {
                NotificationReceptor::updateOrCreate(
                    [
                        'note_enum_id' => $note_enum_id,
                        'school_id' => $school_id,
                        'notification_id' => $notification->id,
                        'user_type' => 'employee',
                        'user_id' => $user_id,
                    ],[
                        'seen' => 0,
                        'open' => 0,
                    ]
                );
            } else {
                NotificationReceptor::updateOrCreate(
                    [
                        'note_enum_id' => $note_enum_id,
                        'school_id' => $school_id,
                        'notification_id' => $notification->id,
                        'user_type' => 'employee',
                        'user_id' => $user_id,
                    ],
                    [
                        'seen' => 0,
                        'open' => 0,
                    ]
                );
            }
            // $user = User::find($user_id);
            // $firebaseToken = $user->firebase_token;
            // if ($firebaseToken) {
            //     $this->sendFirebaseNotification($firebaseToken, $title, $body);
            // }
        }
    }


    // --------------  Mobile Notification
    public function CreateMobileNotification(
        string $title,
        string $body,
        string $school_id,
        array $user_ids,
        string $model = null,
        int $model_id = null,
        string $date = null,
        string $receptor = "specific_receptors"
    ) {
        $notification = Notification::create([
            'title' => $title,
            'body' => $body,
            'receptor' => $receptor,
            'model' => $model,
            'model_id' => $model_id,
            'date' => $date,
            'date_type' => 'coptic',
            'notification_type' => 'app',
        ]);
        foreach ($user_ids as $user_id) {
            NotificationReceptor::create([
                'school_id' => $school_id,
                'user_id' => $user_id,
                'user_type' => 'employee',
                'notification_id' => $notification->id,
            ]);

            // $user = User::find($user_id);
            // $firebaseToken = $user->firebase_token;
            // if ($firebaseToken) {
            //     $this->sendFirebaseNotification($firebaseToken, $title, $body);
            // }

        }
    }

    protected function sendFirebaseNotification($token, $title, $body)
    {
        $message = [
            'token' => $token,
            'notification' => [
                'title' => $title,
                'body' => $body,
            ],
            'data' => [
                'click_action' => 'FLUTTER_NOTIFICATION_CLICK', // Adjust to match Next.js handling
            ],
        ];

        return $this->messaging->send($message);
    }
}
