<?php

namespace App\Traits;

use Alkoumi\LaravelHijriDate\Hijri;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\Namazeg;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

trait NamazegTrait
{
    public static function storeNamazegVersion($namazeg_id, $type, $school_id, $user_id = null)
    {
        $current_year = substr(Hijri::Date('Y'), -2);
        $hijri_month = Hijri::Date('m');
        $version = 1; 
        $namozeg = Namazeg::findOrFail($namazeg_id);
        $school = School::findOrFail($school_id);
        if ($type == "internal") {
            $base_serial_number = $current_year.'-'. $namazeg_id.'-';
            do{
                $new_serial_number = $base_serial_number . $version;
                $serial_number = NamazegVersion::where('serial_number', $new_serial_number)->first();
                if ($serial_number) {
                    $version++;
                }
            } while($serial_number);
        } else {
            $base_serial_number = $current_year . '-' . $hijri_month. '-' . $school->ministry_number . '-';
            do {
                $new_serial_number = $base_serial_number . $version;
                $serial_number = NamazegVersion::where('serial_number', $new_serial_number)->first();
                if ($serial_number) {
                    $version++;
                }
            } while ($serial_number);
        }
        $namozeg_version = NamazegVersion::create([
            'namazeg_id' => $namozeg->form_number,
            'school_id' => $school_id,
            'user_id' => $user_id,
            'serial_number' => $new_serial_number,
        ]);
        return $namozeg_version;
    }
}
