<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\MeetingResource;
use App\Models\ManagerDashboard\Assignments\AssignmentTeam;
use Carbon\Carbon;

class NamozegAssignmentTeamHandler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query =  AssignmentTeam::with('team.members')->where('school_id', $school->id)->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $assignmentTeam = $query->firstOrFail();

        return [
            'team_id' => $assignmentTeam->team->id,
            'name' => $assignmentTeam->team->name,
            'assignment_form_number' => $assignmentTeam->team->assignment_form_number,
            'assignment' =>  $assignmentTeam ? [
                'assignment_id' =>  $assignmentTeam->id,
                'school_id' => $assignmentTeam->school_id,
                'namozeg_serial_number' => $assignmentTeam->namozegVersion->serial_number,
                'assignment_date' => Carbon::createFromFormat('d/m/Y', $assignmentTeam->date)->format('d/m/Y'),
                'date_options' => Helper::getDateOptions($assignmentTeam->date, $assignmentTeam->type),
                'members' => $assignmentTeam->team->members
                    ? $assignmentTeam->team->members->filter(function ($member) use($assignmentTeam) {
                        return $member->assignment_team_id ==  $assignmentTeam->id;
                    })->map(function ($member) {

                        return [
                            'employee_id' => $member->employee_id,
                            'employee_name' => $member->employee->name,
                            'assignment_work' => $member->assignment_work,
                        ];
                    })->values() // Reset the keys here
                    : [],
                'meetings' => $assignmentTeam->team->meetings
                    ? $assignmentTeam->team->meetings->filter(function ($meeting) {
                        return $meeting->meeting_type == 'دوري';
                    })->values()->map(function ($meeting) {
                        return new MeetingResource($meeting);
                    })
                    : [],
            ] : [],


        ];
       
    }
}
