<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\MeetingResource;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use Carbon\Carbon;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Meeting;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\School;

class NamozegAssignmentCommitteeHandler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query =  AssignmentCommittee::with('committee.members')->where('school_id', $school->id)->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $assignmentCommittee = $query->firstOrFail();

        $committee = $assignmentCommittee->committee;

        $meetings = Meeting::where('model_id', $committee->id)->get();

        // Group meetings by semester_id
        $groupedMeetings = $meetings->groupBy('semester_id')->map(function ($group, $semesterId) {
            // Assuming you have a Semester model to get the semester details
            $semester = SchoolSemester::find($semesterId); // Fetch the semester details
        
            return [
                'semester_id' => $semester->id,
                'semester_name' => $semester->name,
                'meetings' => $group->map(function ($meeting) {
                    return [
                        'id' => $meeting->id,
                        'name' => $meeting->name,
                        'place' => $meeting->place,
                    ];
                })->values()->toArray(), 
            ];
        });


        $semesterMeetings = $groupedMeetings->values()->toArray();

        $school_manager = SchoolEmployee::select('id', 'name')
        ->where('school_id', $school->id)
        ->where('current_work_id', 1)
        ->first();
        $current_school_year = School::findOrFail($school->id)->current_school_year;


        return [
            'committee_id' => $assignmentCommittee->committee->id,
            'name' => $assignmentCommittee->committee->name,        
            'assignment_form_number' => $assignmentCommittee->committee->assignment_form_number,
            'assignment' =>  $assignmentCommittee ? [
                'assignment_id' =>  $assignmentCommittee->id,
                'school_id' => $assignmentCommittee->school_id,
                'namozeg_serial_number' => $assignmentCommittee->namozegVersion->serial_number,
                'assignment_date' => Carbon::createFromFormat('d/m/Y', $assignmentCommittee->date)->format('d/m/Y'),
                'date_options' => Helper::getDateOptions($assignmentCommittee->date, $assignmentCommittee->type),
                'members' => $assignmentCommittee->committee->members
                    ? $assignmentCommittee->committee->members->filter(function ($member) use($assignmentCommittee) {
                        return $member->assignment_committee_id ==  $assignmentCommittee->id;
                    })->map(function ($member) {

                        return [
                            'employee_id' => $member->employee_id,
                            'employee_name' => $member->employee->name,
                            'assignment_work' => $member->assignment_work,
                        ];
                    })->values() // Reset the keys here
                    : [],
                // 'meetings' => $assignmentCommittee->committee->meetings
                //     ? $assignmentCommittee->committee->meetings->filter(function ($meeting) {
                //         return $meeting->meeting_type == 'دوري';
                //     })->values()->map(function ($meeting) {
                //         return new MeetingResource($meeting);
                //     })
                //     : [],

                    'meetings' => $semesterMeetings
            ] : [],


        'school_manager'=>$school_manager ,
        'current_school_year' => $current_school_year
    ];
       
    }
}














// <?php

// namespace App\Strategies;

// use App\Helpers\Helper;
// use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\MeetingResource;
// use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
// use Carbon\Carbon;
// use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Meeting;
// use Illuminate\Support\Facades\DB;
// use  App\Models\AdminDashboard\School\SchoolSemester;
// class NamozegAssignmentCommitteeHandler implements NamozegStrategy
// {
//     public function handle($school, $request, $namozeg_version)
//     {
//         $assignmentCommittee =  AssignmentCommittee::with('committee.members')->where('school_id', $school->id)->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
//         $committee = $assignmentCommittee->committee;

//         $meetings = Meeting::where('model_id', $committee->id)->get();

//         // Group meetings by semester_id
//         $groupedMeetings = $meetings->groupBy('semester_id')->map(function ($group, $semesterId) {
//             // Assuming you have a Semester model to get the semester details
//             $semester = SchoolSemester::find($semesterId); // Fetch the semester details
        
//             return [
//                 'semester_id' => $semester->id,
//                 'semester_name' => $semester->name,
//                 'meetings' => $group->map(function ($meeting) {
//                     return [
//                         'id' => $meeting->id,
//                         'name' => $meeting->name,
//                         'place' => $meeting->place,
//                         // Add other fields as necessary
//                     ];
//                 })->values()->toArray(), // Ensure meetings are returned as an array
//             ];
//         });


//         $semesterMeetings = $groupedMeetings->values()->toArray();
        
//         return [
//             'committee_id' => $assignmentCommittee->committee->id,
//             'name' => $assignmentCommittee->committee->name,
//             'assignment_form_number' => $assignmentCommittee->committee->assignment_form_number,
//             'assignment' =>  $assignmentCommittee ? [
//                 'assignment_id' =>  $assignmentCommittee->id,
//                 'school_id' => $assignmentCommittee->school_id,
//                 'namozeg_serial_number' => $assignmentCommittee->namozegVersion->serial_number,
//                 'assignment_date' => Carbon::createFromFormat('d/m/Y', $assignmentCommittee->date)->format('d/m/Y'),
//                 'date_options' => Helper::getDateOptions($assignmentCommittee->date, $assignmentCommittee->type),
//                 'members' => $assignmentCommittee->committee->members
//                     ? $assignmentCommittee->committee->members->filter(function ($member) use($assignmentCommittee) {
//                         return $member->assignment_committee_id ==  $assignmentCommittee->id;
//                     })->map(function ($member) {

//                         return [
//                             'employee_id' => $member->employee_id,
//                             'employee_name' => $member->employee->name,
//                             'assignment_work' => $member->assignment_work,
//                         ];
//                     })->values() // Reset the keys here
//                     : [],
//                 'meetings' => $semesterMeetings->committee->meetings
//                     ? $assignmentCommittee->committee->meetings->filter(function ($meeting) {
//                         return $meeting->meeting_type == 'دوري';
//                     })->values()->map(function ($meeting) {
//                         return new MeetingResource($meeting);
//                     })
//                     : [],

//                 // 'meetings' => $semesterMeetings
//             ] : [],


//         ];
       
//     }
// }
