<?php

namespace App\Strategies;

use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\MonitorDistribtionAssignmentResource;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions\DistributionAssignment;
use App\Helpers\Helper;
class Namozeg81Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $query = DistributionAssignment::with('monitors')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $distribtionAssignments = $query->firstOrFail();
        $school_manager = SchoolEmployee::select('id', 'name')
            ->where('school_id', $school->id)
            ->where('current_work_id', 1)
            ->first();

        // Get current school year and semester
        $current_school_year = $school->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];

        $commonResponse = [
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
            'floor' => 'الاول',
        ];
        return [
            'distribution_assignments' => new MonitorDistribtionAssignmentResource($distribtionAssignments),
            'school_manager' => $school_manager,
            'school_context' => $commonResponse,
        ];
    }
}
