<?php

namespace App\Strategies;

use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\TeacherCurriculumDeclarationResource;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherDeclaration\TeacherCurriculumDeclaration;
use App\Helpers\Helper;

class Namozeg75Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $query = TeacherCurriculumDeclaration::with('namozegVersion', 'employee')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $assignment = $query->firstOrFail();

        $resource = new TeacherCurriculumDeclarationResource($assignment);

        // Get current school year and semester
        $current_school_year = $school->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];

        $commonResponse = [
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
            'floor' => 'الاول',
        ];
        return [
            'data' => array_merge($commonResponse, $resource->toArray($request))
        ];
    }
}
