<?php

namespace App\Strategies;

use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignmentResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAbsenceProcedureSubItem;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment;
use App\Helpers\Helper;

class Namozeg68Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {

        $query = TeacherQuestionAssignment::with('namozegVersion', 'employee')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $assignment = $query->firstOrFail();
        $resource = new TeacherQuestionAssignmentResource($assignment);

        // Get current school year and semester
        $current_school_year = $school->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];
        $school_manager = SchoolEmployee::select('id', 'name')
        ->where('school_id', $school->id)
        ->where('current_work_id', 1)
        ->first();

        $commonResponse = [
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
            'floor' => 'الاول',
            'school_manager'=>$school_manager
        ];
        return [
            'data' => array_merge($commonResponse, $resource->toArray($request))
        ];



    }
}
