<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsSchedule;

class Namozeg51Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = WaitingPeriodsSchedule::with(['schedule_data' => function ($q) {
            return $q->orderBy('period_id', 'ASC');
        }])->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();

        $day = SemesterWeekDay::where('date', $namozeg->creation_date)->first()?->day?->name;
        
        foreach ($namozeg->schedule_data as $value) {
            $details[] = [
                'period' => $value?->period?->name,
                'class_name' => $value?->class?->className?->name,
                'class_number' => $value?->class?->class_number,
                'subject' => $value?->subject?->name,
                'alternative_employee' => $value?->alternative_employee?->name,
            ];
        }

        return [
            'absent_employee' => $namozeg->absent_employee->name,
            'day' => $day,
            'date_options' => Helper::getDateOptions($namozeg->creation_date, 'coptic'),
            'details' => $details,
        ];
    }
}
