<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Tables\Exams\TableExam;
use App\Models\ManagerDashboard\Tables\Exams\TableExamNamazeg;
use App\Models\ManagerDashboard\Tables\Exams\TableExamInstruction;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\ManagerDashboard\Tables\Exams\TableExamDay;
use App\Http\Resources\ManagerDashboard\Tables\Exams\TableExamNamazegResource;
use App\Http\Resources\ManagerDashboard\Tables\Exams\TableExamDayResource;

use Carbon\Carbon;

class Namozeg248Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $namozeg = TableExamNamazeg::where('namazeg_version_id', $namozeg_version->id)->first();
        $tableExamId = $namozeg->table_exam_id;
        $tableExam = TableExam::where('id',$tableExamId);

        if($type == 'trashed') {
            $tableExam->withTrashed();
        }

        $tableExam = $tableExam->firstOrFail();


        $classNameIds = TableExamNamazeg::where('namazeg_version_id', $namozeg_version->id)->first()->class_name_id;
        $examTableData=  collect($classNameIds)->map(function ($classNameId) use ($tableExamId){

            $className = ClassName::find($classNameId);

            /** school calsses and their ids*/
            $schoolClassId = TableExamDay::where('table_exam_id', $tableExamId )->where('class_name_id',$classNameId)->whereNotNull('class_id')->pluck('class_id')->unique()->toArray();

            $schoolClass = SchoolClass::whereIn('id',$schoolClassId)->first();

            $tableExamDays = TableExamDayResource::collection(TableExamDay::where('table_exam_id',$tableExamId)->where('class_name_id',$classNameId)->get());
            $data=[
                'class_name'=>$className->name,
                'school_class'=>$schoolClass? $schoolClass->class_number : '',
                'tableExamDays'=>$tableExamDays
            ];

            return $data;
        })->all();


        $tableExamDays = TableExamDay::where('table_exam_id', $tableExamId)->where('class_name_id',$namozeg->class_name_id)->get();
        $tableExamDayLeaveTimes = $tableExamDays->map(function ($tableExamDay) {
            return [
                'day'=>$tableExamDay->semesterWeekDay?->day?->name.'',
                'leave_time'=>$tableExamDay->leave_time?$tableExamDay->leave_time:'',
            ];
        });

        $schoolManager = SchoolEmployee::where('school_id' , $school->id)->first();
        $examInstructions = TableExamInstruction::findOrFail(1);


        return [
            'school_year' => Helper::getSchoolYear(),
            'semester' => $tableExam->semester?->name,
            'entsab'=>$tableExam->entsab,
            'table_exam'=>$examTableData,
            'school_manager'=>$schoolManager->name,
            'exam_instructions'=>$examInstructions->text,
            'table_exam_days_leave_times'=>$tableExamDayLeaveTimes,
        ];
    }


}
