<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAbsenceProcedure;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLatenessProcedure;

class Namozeg227Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = StudentLatenessProcedure::with('student')->where('namozeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'student_name' => $namozeg->student->name,
            'class_name' => $namozeg->student->SchoolClass->className->name,
            'current_school_year' => $school->current_school_year,
            'manager_name' => $manager_name,
        ];
    }
}
