<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Circulars\TeacherGeneralCircular;

class Namozeg225Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $query = TeacherGeneralCircular::with('teachers')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $teachers = $namozeg->teachers()->get()->map(function ($item) {
            return [
                'name' => $item->name,
                'ssn' => $item->ssn,
                'current_work' => $item->currentWork->job_title,
            ];
        });

        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'about' => $namozeg->title,
            'to' => $teachers,
            'manager_name' => $manager_name,
        ];
    }
}
