<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassRoomvisitResource;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;

class Namozeg202Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {

        $semester_id = ClassRoomVisitSession::where('namazeg_version_id', $namozeg_version->id)
            ->where('school_id', $school->id)->firstOrFail()->semester_id;

        $ClassRoomVisitSessions =   ClassRoomVisitSession::where('semester_id', $semester_id)->get();

        if ($type == 'trashed') {
            $semester_id->withTrashed();
        }



        $school_manager = SchoolEmployee::select('id', 'name')
            ->where('school_id', $school->id)
            ->where('current_work_id', 1)
            ->first();



        $data = $ClassRoomVisitSessions->map(function ($ClassRoomVisitSession) {
            return [
                'id' => $ClassRoomVisitSession->id,
                'serial_number' => $ClassRoomVisitSession->namozegVersion?->serial_number,
                'rate_serial_number' => $ClassRoomVisitSession->rate_namozegVersion?->serial_number,
                'semester_id' => $ClassRoomVisitSession->semester?->id,
                'semester' => $ClassRoomVisitSession->semester?->name,
                'teacher' => $ClassRoomVisitSession->teacher?->name,
                'teacher_specialization' => $ClassRoomVisitSession->teacher->specialization?->title,
                'school_class_id' => $ClassRoomVisitSession->school_class_id,
                'class_id' => $ClassRoomVisitSession->class->className?->id,
                'class' => $ClassRoomVisitSession->class->className?->name,
                'classNumber' => $ClassRoomVisitSession->class?->class_number,
                // 'date' => $date,
                'dat_options' => Helper::getDateOptions($ClassRoomVisitSession->date, $ClassRoomVisitSession->date_type),
                'date_type' => $ClassRoomVisitSession->date_type,
                'visitOfficer' => $ClassRoomVisitSession->visitOfficer?->name,
                'period_id' => $ClassRoomVisitSession->period?->id,
                'visitPeriod' => $ClassRoomVisitSession->period?->name,
                'subject_id' => $ClassRoomVisitSession->subject?->id,
                'subject' => $ClassRoomVisitSession->subject?->name,
                'visitStatus' => $ClassRoomVisitSession->visit_status,
                'teacher_num_visits' => $teacher_num_visits ?? 0
            ];
        });

        return [
            'data' => $data,
            'school_manager' => $school_manager
        ];
    }
}
