<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegFinalReportClassActivity;
use Carbon\Carbon;

class Namozeg188Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegFinalReportClassActivity::where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $emplyees_name = $namozeg->employees->pluck('name');
        // ---------------------------  404 رئيس فريق حصص الاتقان
        // $manager_assistant_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 6)->first()?->name;
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'school_name' => $school->name,
            'department_name' => $school->educationDepartment?->name,
            'n_medical_sessions' => $namozeg->n_medical_sessions,
            'percent_medical_sessions' => $namozeg->percent_medical_sessions,
            'n_ernrichment_sessions' => $namozeg->n_ernrichment_sessions,
            'percent_ernrichment_sessions' => $namozeg->percent_ernrichment_sessions,
            'emplyees_name' => $emplyees_name,
            'difficulty' => $namozeg->difficulty,
            'challenges' => $namozeg->challenges,
            'solutions' => $namozeg->solutions,
            'suggestions' => $namozeg->suggestions,
            'manager_assistant_name' => "manager_assistant_name",
            'date_options' => Helper::getDateOptions($namozeg->date, 'coptic')

        ];
    }
}
