<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolGrade;
use App\Models\ManagerDashboard\Namazeg\NamazegClassPlanActivity;

class Namozeg186Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegClassPlanActivity::where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $employees_name = $namozeg->employees->pluck('name');
        $specializations = $namozeg->specializations;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        //وكيل شؤون الطلاب
        $manager_assistant_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 7)->first()?->name;
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'school_name' => $school->name,
            'manager_name' => $manager_name,
            'classes_manager' => $manager_assistant_name,
            'n_classes' => $namozeg->n_classes,
            'employees_name' => $employees_name,
            'specializations_name' => $specializations->pluck('title'),
            'specializations_ids' => $specializations->pluck('id'),
        ];
    }
}
