<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegExcessDamageRecord;
use Carbon\Carbon;

class Namozeg180Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegExcessDamageRecord::with('employee')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        // وكيل الشئون المدرسية
        $supervisor_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 8)->first()?->name;
        $current_semester = Helper::getCurrentSchoolSemester();

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'current_semester' => $current_semester->name,
            'employee_name' => $namozeg->employee->name,
            'supervisor_name' => $supervisor_name
        ];
    }
}
