<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegLabInventoryRecord;

class Namozeg164Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegLabInventoryRecord::with('employee')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        // وكيل الشئون المدرسية
        $supervisor_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 8)->first()?->name;

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'employee_name' => $namozeg->employee->name,
            'supervisor_name' => $supervisor_name 
        ];
    }
}
