<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegRecieptRecord;
use Carbon\Carbon;

class Namozeg163Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegRecieptRecord::with('employee')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'employee_name' => $namozeg->employee->name,
            'current_work' => $namozeg->employee->currentWork?->job_title,
        ];
    }
}
