<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegMaintenanceForm;

class Namozeg162Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegMaintenanceForm::where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $current_semester = Helper::getCurrentSchoolSemester();

        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        // وكيل الشئون المدرسية
        $supervisor_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 8)->first()?->name;

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'current_semester' => $current_semester?->name,
            'school_name' => $school->name,
            'school_grade' => $school->schoolGrade->name,
            'ministry_number' => $school->ministry_number,
            'tel_phone' => $school->refrence?->tel_phone,
            'phone' => $school->refrence?->phone,
            'maintenance_type' => $namozeg->maintenance_type,
            'other_type' => $namozeg->other_type,
            'maintenance_desc' => $namozeg->maintenance_desc,
            'is_urgent' => $namozeg->is_urgent,
            'date_type_prefered' => $namozeg->date_type_prefered,

            'manager_name' => $manager_name,
            'supervisor_name' => $supervisor_name
        ];
    }
}
