<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegAcceptStudent;

class Namozeg158Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegAcceptStudent::with('class')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'school_name' => $school->name,
            'manager_name' => $manager_name,
            'student_name' => $namozeg->student_name,
            'nationality' => $namozeg->nationality,
            'ssn' => $namozeg->ssn,
            'class_id' => $namozeg->class->name,
            'from_school_manager' => $namozeg->from_school_manager
        ];
    }
}
