<?php

namespace App\Services\Exams;

use App\Http\Resources\ManagerDashboard\Exams\StudentCommittes\ClassResource;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\Student;
use Illuminate\Support\Facades\DB;

class ClassService
{
    public function getSchoolClasses($school)
    {

        $entezamClasses = ClassName::with(['schoolClasses' => function ($query) use ($school) {
            $query->where('entsab', 'no')
                ->where('school_id', $school->id);
        }])
            ->whereIn('id', function ($query) use ($school) {
                $query->select(DB::raw('MIN(id)'))
                    ->from('class_names')
                    ->where('school_grade_id', $school->school_grade_id)
                    ->where('school_id', $school->id)
                    ->groupBy('name'); // Group by 'name' for distinct results
            })->get();

        $entsabClasses = ClassName::with(['schoolClasses' => function ($query) use ($school) {
            $query->where('entsab', 'yes')
                ->where('school_id', $school->id);
        }])
            ->whereIn('id', function ($query) use ($school) {
                $query->select(DB::raw('MIN(id)'))
                    ->from('class_names')
                    ->where('school_grade_id', $school->school_grade_id)
                    ->where('school_id', $school->id)
                    ->groupBy('name'); // Group by 'name' for distinct results
            })->get();

        return response()->json([
            'entezamClasses' => ClassResource::collection($entezamClasses),
            'entsabClasses' => ClassResource::collection($entsabClasses),
        ]);
    }

    public function getExamStudentsCount($school)
    {

        $entezamStudents = Student::where('school_id', $school->id)
            ->whereHas('schoolClass', function ($query) {
                $query->where('entsab', 'no');
            })
            ->count();

        $entsabStudents = Student::where('school_id', $school->id)
            ->whereHas('schoolClass', function ($query) {
                $query->where('entsab', 'yes');
            })
            ->count();


        return  response()->json([
            'entsabStudents' => $entsabStudents,
            'entezamStudents' => $entezamStudents
        ]);
    }

    public function getCommitteeLocations($school)
    {
        $classesWithoutCommittees = $school->classes->reject(function ($class) {
            $class->entsab === 'yes';
            // return $class->studentCommittees->isNotEmpty() || $class->entsab !== 'yes';
            return $class->studentCommittees->isNotEmpty() ;

        });
     
        $locations = [      
            'المسرح',
            'المختبر',
            'مصادر التعلم',
            'غرفة الاجتماعات',
            'فناء خارجي',
        ];
      
        foreach ($classesWithoutCommittees as $classesWithoutCommittee) {
            $locations[] = $classesWithoutCommittee->className->name .' '.$classesWithoutCommittee->class_number;
        }
        
        return response()->json(['locations' => $locations]) ;
    }
}
