<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class UniqueAssignmentWorkRole implements ValidationRule
{
    private $members;
    private $role;

    public function __construct($members, $role)
    {
        $this->members = $members;
        $this->role = $role;
    }

    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        
        $count = 0;

        foreach ($this->members as $member) {
            if ($member['assignment_work'] === $this->role) {
                $count++;
            }
        }

        // Skip validation for 'عضو' role (allow multiple)
        if ($this->role === 'عضو') {
            return;
        }

        // Fail validation if the role appears more than once
        if ($count > 1) {
            $fail("The role '{$this->role}' can only be assigned once.");
        }
    }
}