<?php

namespace App\Providers;

use App\Services\DatabaseContext;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\{DB, Cache, Log};
use PHPOpenSourceSaver\JWTAuth\Facades\JWTAuth;
use Illuminate\Http\Request;

class AppServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(Request $request): void
    {
        try {
            $user = null;
            
            // Always try to get user from bearer token first
            if ($request->bearerToken()) {
                try {
                    $user = JWTAuth::parseToken()->authenticate();
                } catch (\Exception $e) {
                    Log::error('JWT Authentication Error: ' . $e->getMessage());
                }
            }
            
            // Register the singleton
            $this->app->singleton('AppServiceProviderUser', function () use ($user) {
                return $user;
            });

            // Check and switch database if needed
            if ($user && DatabaseContext::isArchiveMode($user)) {
                $tempDatabase = DatabaseContext::getCurrentPreviewDatabase($user);
                
                if ($tempDatabase) {
                    // Create temporary connection configuration
                    $tempConfig = config('database.connections.mysql');
                    $tempConfig['database'] = $tempDatabase;
                    
                    // Register and switch to temporary connection
                    config(['database.connections.temp_preview' => $tempConfig]);
                    DB::setDefaultConnection('temp_preview');
                }
            }
        } catch (\Exception $e) {
            Log::error('AppServiceProvider Error: ' . $e->getMessage());
        }
    }
}