<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class ViolationPunishment extends Model
{ 
    use HasFactory;

    protected $table='violation_punishments';
    protected $guarded=[];

    public function namzeg(){
        return $this->belongsTo(Namazeg::class, 'violation_punishment_id')->select('id','name','details', 'form_number');
    }

    public function related_punishments(){
        return $this->hasMany(BasicRelativePunishment::class, 'relation_violation_punishment_id')->with('namzeg');
    }



}
