<?php

namespace App\Models;

use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrashedRecord extends Model
{
    use HasFactory;
    protected $fillable = ['model', 'record_id','namazeg_version_id','school_id','deleted_at'];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
    
    protected $casts = [
        'deleted_at' => 'datetime', // Ensures deleted_at is treated as a Carbon instance
    ];
}
