<?php

namespace App\Models\ManagerDashboard\Violations;

use App\Models\ViolationTitle;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class ViolationStudentTitle extends Model
{
    use HasFactory;

    protected $table= 'violation_student_titles';
    protected $guarded=[];

    public function punishments(){
        return $this->hasMany(ViolationStudentPunishment::class, 'violation_student_title_id')->with('namozeg', 'namozegVersion');
    }

    public function ViolationStudent(){
        return $this->belongsTo(ViolationStudent::class, 'violation_student_id')->with('student', 'violationGrade', 'category');
    }

    public function title(){
        return $this->belongsTo(ViolationTitle::class, 'violation_title_id')->with('violation_name');
    }

}
