<?php

namespace App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\Day;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WaitingPeriodsSchedule extends Model
{
    use HasFactory,SoftDeletes,CascadeSoftDeletes;

    protected $table = 'waiting_periods_schedules';
    protected $guarded = [];
    protected $cascadeDeletes = ['schedule_data'];
    protected $appends = ['serial_number','namozeg_name'];


    public function semester(){
        return $this->belongsTo(SchoolSemester::class,'semester_id');
    }

    public function absent_employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'school_employee_id');
    }
    
    public function day_name()
    {
        return $this->belongsTo(Day::class, 'day_id');
    }

    public function namozegVersion(){
        return $this->belongsTo(NamazegVersion::class,'namazeg_version_id');
    }

    public function getSerialNumberAttribute()
    {
        return $this->namozegVersion()?->first()?->serial_number;
    }

    public function getNamozegNameAttribute()
    {
        return $this->namozegVersion()?->first()?->namozeg()?->first()?->name;
    }
    
    public function schedule_data()
    {
        return $this->hasMany(WaitingPeriodsScheduleData::class, 'schedule_id');
    }

}
