<?php

namespace App\Models\ManagerDashboard\Tables\Exams;

use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\AdminDashboard\School\Subject;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TableExamDay extends Model
{
    use HasFactory;

    protected $table = 'table_exam_days';
    public $timestamps = false;

    protected $guarded = [];

    public function className(){
        return $this->belongsTo(ClassName::class);
    }

    public function class(){
        return $this->belongsTo(SchoolClass::class);
    }

    public function semesterWeekDay(){
        return $this->belongsTo(SemesterWeekDay::class,'semester_week_day_id');
    }


}
